﻿/**********************************
* @file uart.c
* @brief
* @author
* @version V0.0.0
* @date 2020.02.19
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/
#include "CSU38F20.h"
#include "uart.h"

extern unsigned int adc_samp_result;
extern unsigned char uart_trans_1byte_ok;
//==============================================================	
//  发送和接收UART程序                                                    
//==============================================================

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void uart_init(void)
* @brief  uart init .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void uart_init(void);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  void uart_init(void)
* @brief uart init .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void uart_init(void)
{
	UR0_BRR0 = 208;		//波特率为38400，计算方式为8M/208.3
	UR0_BRR1 = 3;
	uart_clk_div();		//串口时钟为8MHz
	TX9_EN = 0;			//不发送和接收第9位
	RX9_EN = 0;
	TX_EN = 1;			//使能发送
	RX_EN = 0;
	UR_TINV = 0;		//UART输入和输出信号不取反
	UR_RINV = 0;
	UART0_SEL = 1;		//PT5.2为RX，PT5.3为TX
	UR0_INTE = 0b00000001;	//使能UART中断
	GIE = 1;
	UART0_EN = 1;		//打开UART
}

/***********************************
* @fn  void uar(void)
* @brief uart .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void uart(void)
{
	uart_trans_1byte_ok = 0;
	UR0_TX_REG = adc_samp_result>>8;     //发送第一个数据
	while(!uart_trans_1byte_ok);
	uart_trans_1byte_ok = 0;
	UR0_TX_REG = adc_samp_result;	//发送第二个数据
	while(!uart_trans_1byte_ok);
}